//  file: pri.c
//  generator of prime numbers, modulo mapped into 12 pitch classes
//        :
//        enter two integers as range designation (ex.: 1 10 )
//  cc -o pri pri.c

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
//_________________________________________________________________
int isPrime(int i)
{
    int j;
    for(j=2; j<i; j++){
        if(i%j==0){
            return 0;
        }
    }
    return 1;
}
//_________________________________________________________________
void usage (void)
{
    printf("\n\tUSAGE:\n");
    printf("\t\tpri num1 num2\n");
    printf("\t\t    num1 - lower limit\n");
    printf("\t\t    num2 - upper limit\n");
    printf("\t\tgenerate series of 12-tone audio frequencies\n");
    printf("\t\tbased on prime numbers between num1 and num2\n\n");
}
//_________________________________________________________________
int main(int argc, char *argv[])
{
    int n1 = 1, n2 = 1, i;
    float A = 440.;
    
    if ( argc > 3 ){
        usage();
        return 1;
    }
    
    if (argc == 2){
        n2 = atoi(argv[1]);
    }else if (argc == 3) {
        n1 = atoi(argv[1]);
        n2 = atoi(argv[2]);
    }else scanf("%d%d", &n1, &n2);
    
    if(n2 == n1)
        return 2;
    
    if(n1 < 1) n1 = 1;
    if(n2 < 1) n2 = 1;
    
    if(n1 > n2){
        int temp = n1;
        n1 = n2;
        n2 = temp;
    }
    // rectus
    for(i=n1; i<=n2; i++)
    {
        if(isPrime(i))
        {
            int temp = (i - 1)%12;
            int midi =  temp - 9;
            float f  = powf(2., midi/(float)12)*A;
            printf("%.3f\t", f);
        }
    }
    // inversus    
    for(i=n2; i>=n1; i--)
    {
        if(isPrime(i))
        {
            int temp = (i - 1)%12;
            int midi =  12 - temp - 9;
            float f  = powf(2., midi/(float)12)*A;
            printf("%.3f\t", f);
        }
    }        

    printf ("\n");
    return 0;
}