//
//  siner1.c
//  siner1 - demonstration of sine wave sequence production
//           with i/o redirection, piping and text/binary out
//         
//  Created by Stanko Juzbasic on 2/12/15.
//
//  options: -d: <segment_duration_in_seconds>
//           -b   binary write

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <unistd.h>


int main(int argc, char **argv)
{

    float  f[32768];
    int     k = 0;
    float dur =  .125;
    int   opt = 0;
    FILE *out;
    float *am ;
    float R   = 44100. ;    
    int ch;
    char *cvalue = NULL;
    int bin = 0;
    
    while ((ch = getopt (argc, argv, "bd:")) != -1)
        switch (ch){
            case 'b':
                opt = 1;
                bin = 1;
                break;
            case 'd':
                cvalue = optarg;
                dur = (float)atof(cvalue);
                opt = 1;
                break;
            default:
                abort();
        }
    
    if(0)printf("opt = %d\targc = %d\n", opt, argc); 
    
    if(opt){
       if(argc > 3){//4
          for(k = 1+opt; k < argc; k++){//3
              f[k-1-opt] = (float)atof(argv[k]);//3
          }
          k = k - 1 - opt;
          goto r;
       }else goto q; //option with no arguments (-b)
    }else{           //no option
        if(argc > 2){
           for(k = 1; k < argc; k++){
               f[k-1] = (float)atof(argv[k]);
           }
        k--;    
        goto r;
        }
    }
    
    if((!opt)&&(argc == 1)){ //no option, no arguments
q:
        while(scanf("%f", &f[k]) == 1){
            if(f[k] <= 0.)break; //garbage value check
            k++;    
         }
    }
r:
    am  = malloc(sizeof(float));
    if (bin){
        out = fdopen(dup(fileno(stdout)), "wb");        
    }
    
    float phi = 0.;
    float TWOPI = 2.*M_PI;
    
    for (int j = 0; j < k; j++){
        float om     = TWOPI*f[j]/R;      //circular frequency
        size_t length= (size_t)(dur*R);   //length in samples
        float a      = 0.5;
        if(0)    printf("%f\n", f[j]);
    
        for(size_t i = 0; i < length; i++){
            phi += om;
            if(phi > TWOPI)phi -= TWOPI;
            *am = a*sinf(phi);

            if(bin == 1){
                fwrite(am, 1, sizeof *am, out);
            }
            else
                printf("%f\n", *am);
        }
    }
    free(am);
    if (bin) fclose (out); 
    return 0;
}
