//
//  
//  MonoAU code
//
//  Created by Josef K on 27/08/14.
//  Copyright (c) 2014 __MyCompanyName__. All rights reserved.
//

#import "MyTestedPlugin.h"



//Added Render function
//_______________________________________________________________________________________
OSStatus MyTestedPlugin::ProcessBufferLists	(AudioUnitRenderActionFlags &inFlags,
                                         const 	AudioBufferList         &inBufferList,
                                         AudioBufferList                &outBufferList,
                                         UInt32                         inFrames)
{   

    
    //Simple stereo->mono summing callback:

    const Float32 *srcBufferL = (Float32 *)inBufferList.mBuffers[0].mData;
    const Float32 *srcBufferR = (Float32 *)inBufferList.mBuffers[1].mData;
    Float32 *destBufferL = (Float32 *)outBufferList.mBuffers[0].mData;
    Float32 *destBufferR = (Float32 *)outBufferList.mBuffers[1].mData;
    
    Float32 l = 0.;
    Float32 r = 0.;
    Float32 m = 0.;
 
    for(UInt32 frame = 0; frame < inFrames; frame++) {
       
        l = srcBufferL[frame];
        r = srcBufferR[frame];
        m = .5*r + .5*l;
        destBufferL[frame] = m;
        destBufferR[frame] = m;    
    }
    
	return noErr;
}


//_______________________________________________________________________________________
//added 2nd Argument to prevent auval errors : build = OK
MyTestedPlugin::MyTestedPlugin(AudioUnit component) : AUEffectBase(component, false)
{   
    //Added: build = OK
	// suggested for NxM operation by Sophia Poirier of smartelectronix.com
	// on the Core Audio mailing list
    CreateElements();
	CAStreamBasicDescription streamDescIn;
	streamDescIn.SetCanonical(2, false);	// number of input channels
	streamDescIn.mSampleRate = GetSampleRate();
    
	CAStreamBasicDescription streamDescOut;
	streamDescOut.SetCanonical(2, false);	// number of output channels
	streamDescOut.mSampleRate = GetSampleRate();
    
	Inputs().GetIOElement(0)->SetStreamFormat(streamDescIn);
	Outputs().GetIOElement(0)->SetStreamFormat(streamDescOut);
}

UInt32 MyTestedPlugin::SupportedNumChannels (const AUChannelInfo** outInfo)
{   
    // Added: build = OK
	// set an array of arrays of different combinations of supported numbers
	// of ins and outs
	static const AUChannelInfo sChannels[1] = {{ 2, 2}};
	if (outInfo) *outInfo = sChannels;
	return sizeof (sChannels) / sizeof (AUChannelInfo);
}

//_______________________________________________________________________________________
OSStatus MyTestedPlugin::Initialize() 
{   

    //This *MUST* stay intact!
    OSStatus result = AUEffectBase::Initialize();
    // Added: build = OK
    // get the current numChannels for input and output.
	// a host may test various combinations of these
	// regardless of the outInfo returned by our SupportedNumChannels method
	SInt16 auNumInputs = (SInt16) GetInput(0)->GetStreamFormat().mChannelsPerFrame;
	SInt16 auNumOutputs = (SInt16) GetOutput(0)->GetStreamFormat().mChannelsPerFrame;
    
	if ((auNumInputs == 2) && (auNumOutputs == 2))
	{
		MaintainKernels();
		return noErr;
	}
	else
		return kAudioUnitErr_FormatNotSupported;
    // end Added:
    return result;
    
}





