/*
 
     File: MonoPanner.cpp
 Abstract: Audio Unit class implementation.
  Version: 1.0.1
 
 Disclaimer: IMPORTANT:  This Apple software is supplied to you by Apple
 Inc. ("Apple") in consideration of your agreement to the following
 terms, and your use, installation, modification or redistribution of
 this Apple software constitutes acceptance of these terms.  If you do
 not agree with these terms, please do not use, install, modify or
 redistribute this Apple software.
 
 In consideration of your agreement to abide by the following terms, and
 subject to these terms, Apple grants you a personal, non-exclusive
 license, under Apple's copyrights in this original Apple software (the
 "Apple Software"), to use, reproduce, modify and redistribute the Apple
 Software, with or without modifications, in source and/or binary forms;
 provided that if you redistribute the Apple Software in its entirety and
 without modifications, you must retain this notice and the following
 text and disclaimers in all such redistributions of the Apple Software.
 Neither the name, trademarks, service marks or logos of Apple Inc. may
 be used to endorse or promote products derived from the Apple Software
 without specific prior written permission from Apple.  Except as
 expressly stated in this notice, no other rights or licenses, express or
 implied, are granted by Apple herein, including but not limited to any
 patent rights that may be infringed by your derivative works or by other
 works in which the Apple Software may be incorporated.
 
 The Apple Software is provided by Apple on an "AS IS" basis.  APPLE
 MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION
 THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS
 FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND
 OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL
 OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION,
 MODIFICATION AND/OR DISTRIBUTION OF THE APPLE SOFTWARE, HOWEVER CAUSED
 AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE),
 STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE
 POSSIBILITY OF SUCH DAMAGE.
 
 Copyright (C) 2012 Apple Inc. All Rights Reserved.
*/

#include "MonoPanner.h"

//added SJ
//BAD PRACTICE - SHOULD BE DECLARED AS PRIVATE WITHIN THE CLASS!!!
//Float32 prev_param;
//end added

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// COMPONENT_ENTRY(MonoPanner) deprecated on MacOS X 10.7 see TN2276 

AUDIOCOMPONENT_ENTRY(AUBaseFactory, MonoPanner)

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//	MonoPanner::MonoPanner
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*
MonoPanner::MonoPanner(AudioUnit component)
	: AUEffectBase(component)
{
	CreateElements();
	Globals()->UseIndexedParameters(kNumberOfParameters);
	SetParameter(kParam_One, kDefaultValue_ParamOne );
        
#if AU_DEBUG_DISPATCHER
	mDebugDispatcher = new AUDebugDispatcher (this);
#endif
	
}
*/
//_______________________________________________________________________________________
//added 2nd Argument to prevent auval errors : build = OK
MonoPanner::MonoPanner(AudioUnit component) : AUEffectBase(component, false)
{   
    //Added: build = OK
	// suggested for NxM operation by Sophia Poirier of smartelectronix.com
	// on the Core Audio mailing list
    CreateElements();
    
	CAStreamBasicDescription streamDescIn;
	streamDescIn.SetCanonical(2, false);	// number of input channels
	streamDescIn.mSampleRate = GetSampleRate();
    
	CAStreamBasicDescription streamDescOut;
	streamDescOut.SetCanonical(2, false);	// number of output channels
	streamDescOut.mSampleRate = GetSampleRate();
    
	Inputs().GetIOElement(0)->SetStreamFormat(streamDescIn);
	Outputs().GetIOElement(0)->SetStreamFormat(streamDescOut);
    
    Globals()->UseIndexedParameters(kNumberOfParameters);
	SetParameter(kParam_One, kDefaultValue_ParamOne );
    
    //*prev_v = 0.f;
    
#if AU_DEBUG_DISPATCHER
	mDebugDispatcher = new AUDebugDispatcher (this);
#endif
    
    
}
//_______________________________________________________________________________________
UInt32 MonoPanner::SupportedNumChannels (const AUChannelInfo** outInfo)
{   
    // Added: build = OK
	// set an array of arrays of different combinations of supported numbers
	// of ins and outs
	static const AUChannelInfo sChannels[1] = {{ 2, 2}};
	if (outInfo) *outInfo = sChannels;
	return sizeof (sChannels) / sizeof (AUChannelInfo);
}

//_______________________________________________________________________________________
OSStatus MonoPanner::Initialize() 
{   
    
    //This *MUST* stay intact!
    OSStatus result = AUEffectBase::Initialize();
    printf("result = %ld\n", (long)result);
    // Added: build = OK
    // get the current numChannels for input and output.
	// a host may test various combinations of these
	// regardless of the outInfo returned by our SupportedNumChannels method
	SInt16 auNumInputs = (SInt16) GetInput(0)->GetStreamFormat().mChannelsPerFrame;
	SInt16 auNumOutputs = (SInt16) GetOutput(0)->GetStreamFormat().mChannelsPerFrame;
    
    //prev_v = 0.;
    
	if ((auNumInputs == 2) && (auNumOutputs == 2))
	{
		MaintainKernels();
        result = noErr;
		return result;
	}
	else
		return kAudioUnitErr_FormatNotSupported;
    // end Added:
    return result;
    
}



//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//	MonoPanner::GetParameterValueStrings
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
OSStatus
MonoPanner::GetParameterValueStrings(AudioUnitScope		inScope,
                                    AudioUnitParameterID	inParameterID,
                                    CFArrayRef *		outStrings)
{
        
    return kAudioUnitErr_InvalidProperty;
}



//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//	MonoPanner::GetParameterInfo: HERE WE SET PARAM VALUES!
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
OSStatus
MonoPanner::GetParameterInfo(AudioUnitScope		inScope,
                        AudioUnitParameterID	inParameterID,
                        AudioUnitParameterInfo	&outParameterInfo )
{
	OSStatus result = noErr;

	outParameterInfo.flags = 	kAudioUnitParameterFlag_IsWritable
						|		kAudioUnitParameterFlag_IsReadable;
    
    if (inScope == kAudioUnitScope_Global) {
        switch(inParameterID)
        {
            case kParam_One:
                AUBase::FillInParameterName (outParameterInfo, kParameterOneName, false);
                outParameterInfo.unit = kAudioUnitParameterUnit_LinearGain;
                outParameterInfo.minValue = -1.;
                outParameterInfo.maxValue =  1.;
                outParameterInfo.defaultValue = kDefaultValue_ParamOne;
                //AUParameterEventType = kParameterEvent_Ramped;
                break;
            //if we add more parameters, here it has to go in!!
            default:
                result = kAudioUnitErr_InvalidParameter;
                break;
            }
	} else {
        result = kAudioUnitErr_InvalidParameter;
    }
    
	return result;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//	MonoPanner::GetPropertyInfo
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
OSStatus
MonoPanner::GetPropertyInfo (AudioUnitPropertyID	inID,
                            AudioUnitScope		inScope,
                            AudioUnitElement	inElement,
                            UInt32 &		outDataSize,
                            Boolean &		outWritable)
{
	if (inScope == kAudioUnitScope_Global) 
	{
		switch (inID) 
		{
			case kAudioUnitProperty_CocoaUI:
				outWritable = false;
				outDataSize = sizeof (AudioUnitCocoaViewInfo);
				return noErr;
					
		}
	}

	return AUEffectBase::GetPropertyInfo (inID, inScope, inElement, outDataSize, outWritable);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//	MonoPanner::GetProperty
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
OSStatus			
MonoPanner::GetProperty(AudioUnitPropertyID inID,
                       AudioUnitScope 		inScope,
                       AudioUnitElement 	inElement,
                       void *				outData )
{
	if (inScope == kAudioUnitScope_Global) 
	{
		switch (inID) 
		{
			case kAudioUnitProperty_CocoaUI:
			{
				// Look for a resource in the main bundle by name and type.
				CFBundleRef bundle = CFBundleGetBundleWithIdentifier( CFSTR("com.audiounit.MonoPanner") );
				
				if (bundle == NULL) return fnfErr;
                
				CFURLRef bundleURL = CFBundleCopyResourceURL( bundle, 
                    CFSTR("MonoPanner_CocoaViewFactory"), 
                    CFSTR("bundle"), 
                    NULL);
                
                if (bundleURL == NULL) return fnfErr;

				AudioUnitCocoaViewInfo cocoaInfo;
				cocoaInfo.mCocoaAUViewBundleLocation = bundleURL;
				cocoaInfo.mCocoaAUViewClass[0] = CFStringCreateWithCString(NULL, "MonoPanner_CocoaViewFactory", kCFStringEncodingUTF8);
				
				*((AudioUnitCocoaViewInfo *)outData) = cocoaInfo;
				
				return noErr;
			}
		}
	}

	return AUEffectBase::GetProperty (inID, inScope, inElement, outData);
}





//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//	MonoPanner::MonoPannerKernel::Reset()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*
void
MonoPanner::MonoPannerKernel::Reset()
{
}
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//	MonoPanner::MonoPannerKernel::Process
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// The original, intimidatingly arrogant and *stupid*, glitch-producing code was replaced by 
//      a normally functioning, volume-change integrator (SJ)
//__________________________________________________________________________________________
/*
void 
MonoPanner::MonoPannerKernel::Process(const Float32 	*inSourceP,
                                    Float32		 	*inDestP,
                                    UInt32 			inFramesToProcess,
                                    UInt32			inNumChannels, // for version 2 AudioUnits inNumChannels is always 1
                                    bool			&ioSilence )
{
    
	//This code will pass-thru the audio data.
	//This is where you want to process data to produce an effect.
	
	UInt32 nSampleFrames = inFramesToProcess;
	const Float32 *sourceP = inSourceP;
	Float32 *destP = inDestP;
    //Read volume changes once a cycle from "kParam_One"
    //     supplied by the GUI
    Float32 gain = GetParameter( kParam_One );

    //! make array with interpolated gains
    //    static Float32 prev_gain;
    Float32 a[nSampleFrames];
    Float32 step = (gain-prev_gain)/(float)nSampleFrames;
    for (int i = 0; i < nSampleFrames; i++) {
        a[i] = prev_gain + i*step;
    }
    int j = 0;
    
	while (nSampleFrames-- > 0) {
		Float32 inputSample = *sourceP;
		
		//The current (version 2) AudioUnit specification *requires* 
	    //non-interleaved format for all inputs and outputs. Therefore inNumChannels is always 1
		
		sourceP += inNumChannels;	// advance to next frame (e.g. if stereo, we're advancing 2 samples);
        // we're only processing one of an arbitrary number of interleaved channels
        
        // here's where you do the DSP WORK
        //Float32 outputSample = inputSample * gain;
        gain = a[j++];
        Float32 outputSample = inputSample * gain;
		*destP = outputSample;
		destP += inNumChannels;
	}
    //prev_gain = gain;
    //maybe this is better: prev_gain is the last interpolated value
    prev_gain = gain;
}
*/

#pragma mark  - MonoPannerProcessBufferLists -
//_______________________________________________________________________________________

//Added Render function
//_______________________________________________________________________________________
OSStatus MonoPanner::ProcessBufferLists	(AudioUnitRenderActionFlags &inFlags,
                                             const 	AudioBufferList &inBufferList,
                                             AudioBufferList        &outBufferList,
                                             UInt32                 inFrames)
{   
    
    //Float32 p[inFrames];
    //static Float32 prev_v;
    
    
    Float32 param = GetParameter( kParam_One );
    
    param = .5*(param + 1.);
    /*Float32 s = (param-prev_v)/(Float32)inFrames;
    
    for(UInt32 j = 0; j < inFrames; j++)        
        p[j] = prev_v + j*s;
    prev_v = param;
    */
    
    const Float32 *srcBufferL = (Float32 *)inBufferList.mBuffers[0].mData;
    const Float32 *srcBufferR = (Float32 *)inBufferList.mBuffers[1].mData;
    Float32 *destBufferL = (Float32 *)outBufferList.mBuffers[0].mData;
    Float32 *destBufferR = (Float32 *)outBufferList.mBuffers[1].mData;
    
    Float32 l = 0.;
    Float32 r = 0.;

    
    for(UInt32 frame = 0; frame < inFrames; frame++) {
        
        l = srcBufferL[frame];
        r = srcBufferR[frame];
        
        //destBufferL[frame] = l*p[frame] + r*(1.-p[frame]); //r + p[frame]*(l - 1.);
        //destBufferR[frame] = r*p[frame] + l*(1.-p[frame]); //l + p[frame]*(r - 1.);
        destBufferL[frame] = l*param + r*(1.-param); //param * (l - 1.) + r;
        destBufferR[frame] = r*param + l*(1.-param); //param * (r - 1.) + l;      
        
    }
    


	return noErr;
}
//_______________________________________________________________________________________

