/*
 
     File: MonoPanner.h
 Abstract: Audio Unit class definition.
  Version: 1.0.1
 
 Copyright (C) 2012 Apple Inc. All Rights Reserved.
 
 
*/

#include "AUEffectBase.h"
#include "MonoPannerVersion.h"

#if AU_DEBUG_DISPATCHER
	#include "AUDebugDispatcher.h"
#endif


#ifndef __MonoPanner_h__
#define __MonoPanner_h__


#pragma mark ____MonoPanner Parameters

// parameters
static const float kDefaultValue_ParamOne = 0.;//.5

static CFStringRef kParameterOneName = CFSTR("Pan");

enum {
	kParam_One =0,
	//Add your parameters here...
	kNumberOfParameters=1
};
//_____________________________________________________________________________________
#pragma mark ____MonoPanner
class MonoPanner : public AUEffectBase
{
public:
	MonoPanner(AudioUnit component);
    
    /*! @method Version */
	virtual OSStatus		Version() { return kMonoPannerVersion; }
    
    virtual	bool				SupportsTail () { return false; }
/* */   
#if AU_DEBUG_DISPATCHER
	virtual ~MonoPanner () { delete mDebugDispatcher; }
#endif
	
	virtual	OSStatus			GetParameterValueStrings(AudioUnitScope			inScope,
														 AudioUnitParameterID	inParameterID,
														 CFArrayRef *			outStrings);
    
	virtual	OSStatus			GetParameterInfo(AudioUnitScope			inScope,
												 AudioUnitParameterID	inParameterID,
												 AudioUnitParameterInfo	&outParameterInfo);
    
	virtual OSStatus			GetPropertyInfo(AudioUnitPropertyID		inID,
												AudioUnitScope			inScope,
												AudioUnitElement		inElement,
												UInt32 &			outDataSize,
												Boolean	&			outWritable );
	
	virtual OSStatus			GetProperty(AudioUnitPropertyID inID,
											AudioUnitScope 		inScope,
											AudioUnitElement 	inElement,
											void *			outData);
	

    
    //Added: constructors, overridden methods, etc...
public:    
    virtual UInt32 SupportedNumChannels (const AUChannelInfo** outInfo);
    virtual OSStatus Initialize();
private:
    //static Float32* prev_v;
protected:  
    
    virtual OSStatus ProcessBufferLists	(AudioUnitRenderActionFlags     &inFlags,
                                 const 	AudioBufferList         &inBufferList,
                                 AudioBufferList                &outBufferList,
                                 UInt32                         inFrames);
};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


#endif