OSStatus MyAU::ProcessBufferLists	(AudioUnitRenderActionFlags &inFlags,
                                        const 	AudioBufferList &inBufferList,
                                        AudioBufferList         &outBufferList,
                                        UInt32                  inFrames)
{   
    Float32 p[inFrames];
    static Float32 prev_param;
    
    Float32 param = GetParameter( kParam_One );
    param = .5*(param + 1.);
    Float32 s = (param-prev_param)/(Float32)inFrames;
    
    for(UInt32 j = 0; j < inFrames; j++)        
        p[j] = prev_param + j*s;
       
    const Float32 *srcBufferL = (Float32 *)inBufferList.mBuffers[0].mData;
    const Float32 *srcBufferR = (Float32 *)inBufferList.mBuffers[1].mData;
    Float32 *destBufferL = (Float32 *)outBufferList.mBuffers[0].mData;
    Float32 *destBufferR = (Float32 *)outBufferList.mBuffers[1].mData;
    
    Float32 l = 0.;
    Float32 r = 0.;
    
    for(UInt32 frame = 0; frame < inFrames; frame++) {        
        l = srcBufferL[frame];
        r = srcBufferR[frame];
        destBufferL[frame] = l*p[frame] + r*(1.-p[frame]); 
        destBufferR[frame] = r*p[frame] + l*(1.-p[frame]);      
    } 
    
    prev_param = param;
       
	return noErr;
}
